<?php
// =============================
// CONFIGURACIÓN DEL CORREO IMAP
// =============================

// 🔹 RELLENA ESTOS DATOS CON LOS DE TU CORREO
$imap_host  = 'mail.kevinmcr.com';   // Ejemplo: mail.kevinmcr.com o imap.tu-host.com
$imap_port  = 993;                   // Normalmente 993 con SSL
$imap_flags = '/imap/ssl';           // Si tu hosting NO usa SSL, prueba '/imap/notls'
$imap_user  = 'codigos@kevinmcr.com'; // Tu correo completo
$imap_pass  = 'CAMBIA_ESTA_CLAVE';    // Contraseña del correo

// 🔐 Clave para entrar al panel (puedes cambiarla)
// Si la dejas vacía '', no pedirá login
const PANEL_PASSWORD = 'MiClaveSegura123';

session_start();

// --------- LOGIN SENCILLO (opcional) ----------
if (PANEL_PASSWORD !== '' && (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true)) {
    $error_login = '';

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['panel_password'])) {
        if ($_POST['panel_password'] === PANEL_PASSWORD) {
            $_SESSION['logged_in'] = true;
            header('Location: ' . $_SERVER['PHP_SELF']);
            exit;
        } else {
            $error_login = 'Clave incorrecta';
        }
    }

    ?>
    <!doctype html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <title>Acceso - Buscador de códigos</title>
        <style>
            body { font-family: system-ui, sans-serif; background: #000; color: #eee; display:flex; justify-content:center; align-items:center; height:100vh; margin:0; }
            .card { background:#141414; padding:20px; border-radius:10px; width:320px; box-shadow:0 0 10px rgba(0,0,0,0.6); }
            h2 { margin-top:0; color:#e50914; }
            input[type=password], input[type=submit] { width:100%; padding:10px; margin-top:8px; border-radius:6px; border:none; font-size:14px; }
            input[type=password] { background:#222; color:#eee; }
            input[type=submit] { background:#e50914; color:#fff; cursor:pointer; font-weight:bold; }
            .error { margin-top:8px; color:#ffb4b4; font-size:13px; }
            .hint { font-size:12px; color:#aaa; margin-top:6px; }
        </style>
    </head>
    <body>
    <div class="card">
        <h2>Panel de códigos</h2>
        <p>Ingresa la clave para usar el buscador.</p>
        <form method="post">
            <input type="password" name="panel_password" placeholder="Clave del panel" required>
            <input type="submit" value="Entrar">
        </form>
        <?php if (!empty($error_login)): ?>
            <div class="error"><?= htmlspecialchars($error_login, ENT_QUOTES, 'UTF-8') ?></div>
        <?php endif; ?>
        <p class="hint">Este panel es solo para uso interno.</p>
    </div>
    </body>
    </html>
    <?php
    exit;
}

// =============================
// LÓGICA DEL BUSCADOR DE CÓDIGOS
// =============================
$correo_buscar     = '';
$codigo_encontrado = '';
$info_email        = '';
$error_busqueda    = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['correo_buscar'])) {
    $correo_buscar = trim($_POST['correo_buscar']);

    if ($correo_buscar === '') {
        $error_busqueda = 'Ingresa un correo para buscar.';
    } else {
        // Conectar al buzón IMAP
        $mailbox = "{" . $imap_host . ":" . $imap_port . $imap_flags . "}INBOX";

        $inbox = @imap_open($mailbox, $imap_user, $imap_pass);

        if (!$inbox) {
            $error_busqueda = 'No se pudo conectar al correo. Revisa la configuración IMAP (host, puerto, usuario, clave).';
        } else {
            // Buscar correos que contengan ese correo en el texto
            $criteria = 'TEXT "' . addslashes($correo_buscar) . '"';
            $emails = imap_search($inbox, $criteria);

            if (!$emails) {
                $error_busqueda = 'No se encontraron correos relacionados con ese correo de Netflix.';
            } else {
                // Tomar el email más reciente
                rsort($emails); // orden descendente, primero el último
                $ultimo_id = $emails[0];

                // Obtener resumen y cuerpo
                $overview = imap_fetch_overview($inbox, $ultimo_id, 0);
                $overview = $overview[0] ?? null;

                // Intentar obtener el cuerpo completo en varias partes posibles
                $body = imap_fetchbody($inbox, $ultimo_id, "1");
                if (empty($body)) {
                    $body = imap_fetchbody($inbox, $ultimo_id, "1.1");
                }
                if (empty($body)) {
                    $body = imap_fetchbody($inbox, $ultimo_id, "");
                }

                // Decodificar por si viene quoted-printable
                $body = quoted_printable_decode($body);

                // Buscar un código de 6 dígitos (ajusta si tus códigos son distintos)
                if (preg_match_all('/\b(\d{6})\b/', $body, $matches)) {
                    // Tomamos el último código encontrado en el correo
                    $codigo_encontrado = end($matches[1]);
                } else {
                    $error_busqueda = 'Se encontró el correo, pero no se detectó un código de 6 dígitos en el contenido.';
                }

                if ($overview) {
                    $info_email = "Asunto: " . (isset($overview->subject) ? imap_utf8($overview->subject) : '(sin asunto)');
                    $info_email .= " | Fecha: " . ($overview->date ?? '');
                    $info_email .= " | De: " . ($overview->from ?? '');
                }

                imap_close($inbox);
            }
        }
    }
}
?>
<!doctype html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Buscador de códigos Netflix</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: system-ui, sans-serif; background:#000; color:#eee; margin:0; padding:0; }
        header { background:#141414; padding:15px 20px; display:flex; justify-content:space-between; align-items:center; }
        .logo { color:#e50914; font-size:20px; font-weight:bold; }
        .small { font-size:12px; color:#aaa; }
        .container { max-width:600px; margin:20px auto; padding:0 15px; }
        .card { background:#141414; padding:20px; border-radius:10px; box-shadow:0 0 10px rgba(0,0,0,0.6); margin-bottom:20px; }
        h2 { margin-top:0; }
        label { display:block; margin-top:10px; font-size:14px; color:#ccc; }
        input[type=text], input[type=email] {
            width:100%; padding:10px; margin-top:4px; border-radius:6px; border:none;
            background:#222; color:#eee; font-size:14px;
        }
        button {
            margin-top:15px; width:100%; padding:12px; border-radius:6px;
            border:none; background:#e50914; color:#fff; font-size:16px; cursor:pointer; font-weight:bold;
        }
        button:hover { opacity:.9; }
        .msg-error { background:#7f1d1d; color:#fee2e2; padding:10px; border-radius:6px; margin-top:10px; font-size:14px; }
        .msg-ok { background:#064e3b; color:#d1fae5; padding:10px; border-radius:6px; margin-top:10px; font-size:14px; }
        .codigo-box {
            margin-top:15px; padding:15px; background:#000; border-radius:8px;
            border:1px solid #333; text-align:center;
        }
        .codigo {
            font-size:28px; letter-spacing:4px; font-weight:bold; font-family:monospace;
        }
        .info-email { font-size:12px; color:#aaa; margin-top:10px; }
        .nota { font-size:12px; color:#888; margin-top:8px; }
        .logout-form { margin:0; }
        .logout-btn {
            background:none; border:none; color:#eee; font-size:12px; cursor:pointer;
        }
        .logout-btn:hover { text-decoration:underline; }
    </style>
</head>
<body>
<header>
    <div>
        <div class="logo">Buscador de códigos</div>
        <div class="small">Buzón: <?= htmlspecialchars($imap_user, ENT_QUOTES, 'UTF-8') ?></div>
    </div>
    <div>
        <?php if (PANEL_PASSWORD !== ''): ?>
        <form method="post" class="logout-form">
            <input type="hidden" name="do_logout" value="1">
            <button type="submit" class="logout-btn">Cerrar sesión</button>
        </form>
        <?php endif; ?>
    </div>
</header>

<div class="container">
    <div class="card">
        <h2>Buscar código por correo Netflix</h2>
        <p>Escribe el correo de la cuenta Netflix y se buscará el último correo en <b><?= htmlspecialchars($imap_user, ENT_QUOTES, 'UTF-8') ?></b> que contenga ese correo, para extraer el código.</p>

        <form method="post">
            <label>Correo de la cuenta Netflix</label>
            <input type="email" name="correo_buscar" placeholder="ejemplo@correo.com" required
                   value="<?= htmlspecialchars($correo_buscar, ENT_QUOTES, 'UTF-8') ?>">

            <button type="submit">Buscar código</button>
        </form>

        <?php if (!empty($error_busqueda)): ?>
            <div class="msg-error">
                ⚠️ <?= htmlspecialchars($error_busqueda, ENT_QUOTES, 'UTF-8') ?>
            </div>
        <?php endif; ?>

        <?php if ($codigo_encontrado !== ''): ?>
            <div class="msg-ok">
                ✅ Se encontró un código en el último correo relacionado con <b><?= htmlspecialchars($correo_buscar, ENT_QUOTES, 'UTF-8') ?></b>.
            </div>
            <div class="codigo-box">
                <div>Tu código es:</div>
                <div class="codigo"><?= htmlspecialchars($codigo_encontrado, ENT_QUOTES, 'UTF-8') ?></div>
                <?php if (!empty($info_email)): ?>
                    <div class="info-email"><?= htmlspecialchars($info_email, ENT_QUOTES, 'UTF-8') ?></div>
                <?php endif; ?>
            </div>
            <p class="nota">
                Si no coincide con lo que esperas, revisa si el correo correcto está llegando a este buzón
                o si el formato del correo de Netflix cambió.
            </p>
        <?php endif; ?>
    </div>
</div>

<?php
// Logout
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['do_logout'])) {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}
?>
</body>
</html>
